unit FormOsoby;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ActnList, ComCtrls, Buttons, ExtCtrls, Grids, DBGrids, DataModule;

type
  TFOsoby = class(TForm)
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    StatusBar1: TStatusBar;
    ActionList1: TActionList;
    ActionClose: TAction;
    ActionEdit: TAction;
    ActionInsert: TAction;
    ActionDelete: TAction;
    DBGrid: TDBGrid;
    SpeedButton5: TSpeedButton;
    ActionDajPola: TAction;
    SpeedButton6: TSpeedButton;
    ActionFind: TAction;
    SpeedButton7: TSpeedButton;
    ActionRestoreColor: TAction;
    SpeedButton8: TSpeedButton;
    ActionDajProc: TAction;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure DBGridDrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure DBGridKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure ActionCloseExecute(Sender: TObject);
    procedure ActionDajPolaExecute(Sender: TObject);
    procedure ActionFindExecute(Sender: TObject);
    procedure ActionRestoreColorExecute(Sender: TObject);
    procedure ActionEditExecute(Sender: TObject);
    procedure ActionDajProcExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);

  private
    RestoreDefaultColor : Boolean;
  public
    { Public declarations }
    procedure my_edit();


    procedure Daj_pola();
  end;

var
  FOsoby: TFOsoby;

implementation

uses DB, IBQuery, DOsoba;

{$R *.dfm}

procedure TFOsoby.ActionCloseExecute(Sender: TObject);
begin
   Close();
end;

procedure TFOsoby.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TFOsoby.FormDestroy(Sender: TObject);
begin
   if DM.QueryOsoby.Active = True then
   begin
      DM.QueryOsoby.Close();
      DM.QueryOsoby.UnPrepare();
   end;

   FOsoby := Nil;
end;

procedure TFOsoby.FormShow(Sender: TObject);
begin
   RestoreDefaultColor := False;

   if DM.QueryOsoby.Active = False then
   begin
      DM.QueryOsoby.Prepare();
      DM.QueryOsoby.Open();
   end;
end;

procedure TFOsoby.DBGridDrawColumnCell(Sender: TObject;
                                       const Rect: TRect;
                                       DataCol: Integer;
                                       Column: TColumn;
                                       State: TGridDrawState);
var
   lp       : Integer;
   nazwisko : String;
   npesel   : Double;

begin
   (*
   // metody dostpu do pl

   // uwaga na t sytuacj pole nazwisko jest typu znakowego
   npesel   := DM.QueryOsoby.Fields[8].Value;
   // rwnie ta metoda moe by zaskoczeniem:
   npesel := DM.QueryOsoby.FieldValues['PESEL'];

   nazwisko := DM.QueryOsoby.FieldByname('NAZWISKO').AsString;
   nazwisko := DM.QueryOsoby.Fields[1].Value;
   nazwisko := DM.QueryOsoby.FieldValues['NAZWISKO'];
   nazwisko := DM.QueryOsoby['NAZWISKO'];
   *)

   if RestoreDefaultColor = True then
   begin
      DBGrid.Color      := clWindow;
      DBGrid.Color      := clWindow;
   end
   else begin
      // co druga kolumna w innym kolorze
      if (Column.Field = DM.QueryOsoby.FieldByName('NAZWISKO')) or
         (Column.Field = DM.QueryOsoby.FieldByName('DATAUR'))   or
         (Column.Field = DM.QueryOsoby.FieldByName('ULICAINR')) or
         (Column.Field = DM.QueryOsoby.FieldByName('MIASTO')) then
      begin
         DBGrid.Canvas.Font.Color := clWhite;
      end
      else begin
         DBGrid.Canvas.Font.Color := clYellow;
      end;


      (*
      nazwiska o pocztku innym niz 'Kowal' w innym kolorze
      DBGrid.Color := clWindow;
      nazwisko := DM.QueryOsoby.FieldByName('NAZWISKO').AsString;
      if Pos('Kowal', nazwisko) = 0 then begin
         DBGrid.Canvas.Font.Color := clRed;
         DBGrid.Canvas.Font.Style := [fsBold];
      end
      else begin
         DBGrid.Canvas.Font.Color := clBlack;
      end;
      *)
   end;


   // narysuj standardowy tekst - bez tej linii nie zobaczymy efektu
   // zmiany kolorw
   DBGrid.DefaultDrawDataCell(Rect, Column.Field, State);
end;

procedure TFOsoby.DBGridKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if Key = VK_F8 then
   begin
      daj_pola();
   end;
end;

procedure TFOsoby.Daj_pola();
var
   Tab : array of String;   // tablica dynamiczna obiektw typu String
   kk  : integer;           // licznik do sterowania ptl
   txt : String;            // dla celw sprawdzenia wyniku

begin
   for kk := 0 to DM.QueryOsoby.FieldCount-1 do
   begin
      SetLength(Tab, Length(Tab)+1); // powiksz tabel Tab o jeden element
      Tab[kk] := DM.QueryOsoby.Fields[kk].Value; // zapamitaj warto pola
   end;

   // wywietla wyniki
   txt := '';
   for kk := 0 to Length(Tab)-1 do
   begin
      txt := txt + ' ' + Tab[kk];
   end;

   ShowMessage(txt);
end;

procedure TFOsoby.ActionDajPolaExecute(Sender: TObject);
begin
   Daj_pola();
end;

procedure TFOsoby.ActionFindExecute(Sender: TObject);
var
   nazwisko : String;

begin
   nazwisko := InputBox('Okno dialogowe', 'Podaj nazwiska do wyszukania', '');

   if nazwisko <> '' then
   begin
      nazwisko := nazwisko + '%';

      with DM.QueryOsoby do
      begin
         Close();

         SQL.Clear();
         SQL.Add('SELECT * FROM OSOBY where NAZWISKO like :NAZWISKO');
         ParamByName('NAZWISKO').AsString := nazwisko;
         try
            Open();
         except
            Close();
            raise;
         end;
      end;
   end;

end;

procedure TFOsoby.ActionRestoreColorExecute(Sender: TObject);
begin
   RestoreDefaultColor := true;
   DBGrid.Invalidate();
end;

procedure TFOsoby.ActionEditExecute(Sender: TObject);
begin
   my_edit();
end;

procedure TFOsoby.my_edit;
var
   Res : TModalResult;

begin
   DlgOsoba := TDlgOsoba.Create(Self, true);

   try
      Res := DlgOsoba.ShowModal();
   finally
      DM.QueryOsoby.Close();
      DM.QueryOsoby.Open();
   end;
end;

procedure TFOsoby.ActionDajProcExecute(Sender: TObject);
begin
   //
end;

end.

